function p = aic(x)

% p = aic(x,maxp): AR lag-length selection by AIC
%
% INPUT:    x = (n x 1) time-series
%        maxp = max # of lags
%
% OUTPUT:   p = lag-length selected by BIC

n=size(x,1);
maxp=floor(n^(1/3));
T=n-maxp;
Y=x(maxp+1:n);
z=ones(T,1);

i=1;
while i<=maxp;
    if i==1; z=[z,x(maxp:n-1)];
    else; z=[z,x(maxp-i+2:n-i+1)-x(maxp-i+1:n-i)];
    end;
    i=i+1;
end;

i=1;
while i<=maxp;
    v=olsres(Y,z(:,1:i+1)); 
    crit=log(v'*v/T)+(i+1)*2/T; 
    if i<=1; p=i; mincrit=crit; 
    elseif crit<mincrit; p=i; mincrit=crit; end; 
    i=i+1;
end; 